<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserCourse extends Model
{
    protected $table = 'user_courses';
    protected $primaryKey = 'Enrollment_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'Course_id',
        'Progress',
        'Completed_at',
        'created_at',
        'updated_at',
        'Status',
        'Payment_id',
        'Enrollment_number',
        'Assignments_completed',
        'Practice_tests_completed',
        'Mock_interviews_completed',
        'Last_activity', // New field
        'Total_attempts', // New field
        'Completion_status', // New field
    ];

    protected $casts = [
        'Progress' => 'decimal:2',
        'Completed_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'Assignments_completed' => 'integer',
        'Practice_tests_completed' => 'integer',
        'Mock_interviews_completed' => 'integer',
        'Status' => 'string',
        'Last_activity' => 'datetime', // New cast
        'Total_attempts' => 'integer', // New cast
        'Completion_status' => 'string', // New cast
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'Course_id', 'Course_id');
    }

    public function payment()
    {
        return $this->belongsTo(Payment::class, 'Payment_id', 'Payment_id');
    }
}
